﻿cd "C:\Program Files\Octopus Deploy\Tentacle"

function Create-Tentacle ([string] $instance, [string] $port) {
    .\Tentacle.exe create-instance --instance $instance --config "C:\Octopus\$instance\Tentacle.config"
    .\Tentacle.exe new-certificate --instance $instance --if-blank
    .\Tentacle.exe configure --instance $instance --home "C:\Octopus\$instance" --app "C:\Octopus\Applications\$instance" --port $port --noListen "False"
    .\Tentacle.exe configure --instance $instance --reset-trust --trust $OctopusThumbprint
    .\Tentacle.exe service --instance $instance --install --start    
}


function Register-Tentacle ([string] $instance, [string] $environment, [string] $role, [string] $machinePolicy) {
    .\Tentacle.exe register-with --instance $instance --server "$OctopusUrl" --apiKey "$OctopusApiKey" --env $environment --role $role --name $instance --policy "$machinePolicy"   
}

function Delete-Tentacle ([string] $instance) {
    .\Tentacle.exe delete-instance --instance $instance
}


function Get-InstanceName($role) {
    $version = $OctopusParameters['Octopus.Release.Number']
    return "{0}_{1}" -f $role, $version
}

function Get-NextFreePort([int] $portStart) {
    $portOffset = 0
    while ($true) {
        $computer = "localhost"
        $port = 10933 + $portOffset

        $socket = New-Object Net.Sockets.TcpClient
            
        try {
            $socket.Connect($computer, $port)
        }
        catch {
        }
        
        if (!$socket.Connected) {
            return $port
        }

        $socket.Close()        
        $socket.Dispose()
        $socket = $null
        $portOffSet++
    }
}

$environment = $OctopusParameters['Octopus.Environment.Name']

$webServerInstance = Get-InstanceName($OctopusWebServerRole)
$webServerPort = Get-NextFreePort(10933)
Create-Tentacle $webServerInstance $webServerPort
Register-Tentacle $webServerInstance $environment $OctopusWebServerRole $OctopusMachinePolicy


$rateServerInstance = Get-InstanceName($OctopusRateServerRole)
$rateServerPort = Get-NextFreePort(10933)
Create-Tentacle $rateServerInstance $rateServerPort
Register-Tentacle $rateServerInstance $environment $OctopusWebServerRole $OctopusMachinePolicy